' Testing WII Classic Controller for Mouse Capabilities
' Rev 1.0.0 William M Leue 10/5/2020

option default integer
option base 1

const NROWS = 10
const NCOLS = 10
const CSIZE = 30
const MARGIN = 50

' Left and Right Joystick calibration
' These seem weird, likely because mine is a used controller
' Probably these should be the same left and right. Also,
' the maximum and minimum values are not very stable and seem
' to change each time you move the joysticks.
' Regardless, the graphic feedback seems ok.
const LJSNX = 128
const LJSNY = 120
const LJSXMAX = 232
const LJSXMIN = 24
const LJSYMAX = 228
const LJSYMIN = 16
const RJSNX = 120
const RJSNY = 136
const RJSXMAX = 232
const RJSXMIN = 16
const RJSYMAX = 240
const RJSYMIN = 24

' Globals
dim lx = 0
dim prev_lx = 0
dim ly = 0
dim prev_ly = 0
dim rx = 0
dim prev_rx = 0
dim ry = 0
dim prev_ry = 0
dim lxoff = 0 : dim lyoff = 0
dim rxoff = 0 : dim ryoff = 0
dim float plx = 0.0
dim float ply = 0.0
dim hlcx = 0
dim hlcy = 0
dim cx, cy
dim prev_col = 0
dim prev_row = 0

' Main program
DrawGrid
MakeSpriteCursor
OpenWiiController
PollingLoop
CloseWiiController
end

' draw the target grid
sub DrawGrid
  local row, col, x, y

  cls
  text MM.HRES\2, 10, "Use Left Joystick to Maneuver cursor.", "CB"
  text MM.HRES\2, 25, "Click the A button to hilite a grid cell.", "CB
  text MM.HRES\2, 40, "Press any keyboard key to quit.", "CB"
  for row = 1 to NCOLS
    y = MARGIN + (row-1)*CSIZE
    for col = 1 to NCOLS
      x = MARGIN + (col-1)*CSIZE
        box x, y, CSIZE, CSIZE
    next col
  next row
end sub

' open the wii classic controller
sub OpenWiiController
  wii classic open 3, wiicbintr
end sub

' Close the wii classic controller
sub CloseWiiController
  wii classic close
end sub

' Make an arrow sprite cursor
sub MakeSpriteCursor
  sprite load "mouse.spr", 1
end sub

' loop to read WII Classic controller parameters until
' terminated by any keypress
sub PollingLoop
  local ljactive, rjactive

  x$ = INKEY$

  do
 
    lx = classic(LX, 3)
    ly = classic(LY, 3)
    rx = classic(RX, 3)
    ry = classic(RY, 3)
   
    lxoff = 0 : lyoff = 0
    rxoff = 0 : ryoff = 0
    ljactive = 0 : rjactive = 0
    if lx <> prev_lx or ly <> prev_ly then
      ljactive = 1
      plx = (1.0*(lx-LJSNX))/(1.0*(LJSXMAX-LJSNX))
      ply = (1.0*(ly-LJSNY))/(1.0*(LJSYMAX-LJSNY))
      prev_lx = lx : prev_ly = ly
    end if
    if rx <> prev_rx or ry <> prev_ry then
      rjactive = 1
      prx = (1.0*(rx-RJSNX))/(1.0*(RJSXMAX-RJSNX))
      pry = (1.0*(ry-RJSNY))/(1.0*(RJSYMAX-RJSNY))
      prev_rx = rx : prev_ry = ry
    end if
    if ljactive or rjactive then
      UpdateCursor plx, ply
    end if
  loop until INKEY$ <> ""
end sub

end

' wii classic button ISR
sub wiicbintr
  local bmask, test, bx, by

  b = classic(B, 3)
  for i = 0 to 14
    bmask = 2^i
    test = b and bmask
    if test <> 0 and bmask = 2048 then
      HighlightGridCell
    end if
  next i        
end sub

' Maintain the cursor driven by the Classic Controller
' left joystick
' plx and ply valuesrange from -1.0 to + 1.0
sub UpdateCursor px as float, py as float
  local float xs, xe, ys, ye
  
  xs = MARGIN-2*CSIZE : xe = MARGIN + NCOLS*CSIZE + 2*MARGIN
  ys = MARGIN=2*CSIZE : ye = MARGIN + NROWS*CSIZE + 2*MARGIN  
  cx = int(px*((xe-xs)/2.0) + (xe+xs)/2.0 + 0.5)
  cy = int(py*((ye-ys)/2.0) + (ye+ys)/2.0 + 0.5)
  sprite show 1, cx, cy, 1
end sub

' identify grid cell being clicked and highlight it,
' and remove any previous highlight
sub HighlightGridCell 
  local row, col, x, y
  local ok = 1

  if cx < MARGIN+1 or cx > MARGIN+NCOLS*CSIZE-1 then ok = 0
  if cy < MARGIN+1 or cy > MARGIN+NROWS*CSIZE-1 then ok = 0
  if ok = 0 then
    exit sub
  end if
  col = (cx - MARGIN + CSIZE)\CSIZE
  row = (cy - MARGIN + CSIZE)\CSIZE
  if prev_col > 0 and prev_row > 0 then
    x = MARGIN + (prev_col-1)*CSIZE
    y = MARGIN + (prev_row-1)*CSIZE
    box x, y, CSIZE, CSIZE,, RGB(WHITE), RGB(BLACK)
  end if
  prev_col = col : prev_row = row
  x = MARGIN + (col-1)*CSIZE
  y = MARGIN + (row-1)*CSIZE
  sprite hide 1
  box x, y, CSIZE, CSIZE,, RGB(WHITE), RGB(YELLOW)
  sprite show 1, cx, cy, 1
end sub

